<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Account Deletion Confirmation</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f9f9f9;
            margin: 0;
            padding: 0;
        }

        .email-container {
            background-color: #ffffff;
            margin: 20px auto;
            padding: 20px;
            max-width: 600px;
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }

        .header {
            text-align: center;
            margin-bottom: 20px;
        }

        .header img {
            max-width: 120px;
            margin-bottom: 10px;
        }

        .header h1 {
            font-size: 22px;
            color: #333333;
        }

        .content {
            text-align: center;
            color: #666666;
            font-size: 16px;
            line-height: 1.6;
        }

        .content a {
            display: inline-block;
            margin-top: 20px;
            padding: 10px 20px;
            background-color: #ff6347;
            color: #ffffff;
            text-decoration: none;
            font-size: 16px;
            font-weight: bold;
            border-radius: 4px;
        }

        .content a:hover {
            background-color: #ff4a33;
        }

        .footer {
            text-align: center;
            margin-top: 20px;
            font-size: 12px;
            color: #aaaaaa;
        }
    </style>
</head>
<body>
    <div class="email-container">
        <div class="header">
            <h1>Account Deletion Request</h1>
        </div>
        <div class="content">
            <p>Hi,</p>
            <p>We received your request to delete your account. Please confirm this request by clicking the button below. This action is irreversible.</p>
            <a href="https://dishify-server.advisecampus.com/public/account-deletion/confirm/ +<?php echo e($token); ?>" target="_blank" class="button">Confirm Deletion</a>
        </div>
        <div class="footer">
            © <?php echo e(date('Y')); ?> Dishify. All rights reserved.<br>
            If you did not request this, please ignore this email.
        </div>
    </div>
</body>
</html>
<?php /**PATH /Users/hisham/Downloads/dbackend/resources/views/emails/account_deletion_confirmation.blade.php ENDPATH**/ ?>