<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Account Deletion - Dishify</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f9f9f9;
            margin: 0;
            padding: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
        }

        .container {
            background-color: #ffffff;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            border-radius: 8px;
            padding: 30px;
            width: 100%;
            max-width: 400px;
            text-align: center;
        }

        .container h1 {
            color: #333333;
            font-size: 24px;
            margin-bottom: 20px;
        }

        .container p {
            color: #666666;
            font-size: 14px;
            margin-bottom: 20px;
        }

        .form-group {
            margin-bottom: 15px;
            text-align: left;
        }

        .form-group label {
            font-size: 14px;
            color: #333333;
            margin-bottom: 5px;
            display: block;
        }

        .form-group input {
            width: 100%;
            padding: 10px;
            font-size: 14px;
            border: 1px solid #dddddd;
            border-radius: 4px;
            margin-bottom: 10px;
        }

        .btn {
            display: inline-block;
            background-color: #ff6347;
            color: #ffffff;
            padding: 10px 15px;
            font-size: 16px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            text-transform: uppercase;
            font-weight: bold;
        }

        .btn:hover {
            background-color: #ff4a33;
        }

        .footer {
            margin-top: 20px;
            font-size: 12px;
            color: #aaaaaa;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Delete Your Account</h1>
        <p>We're sorry to see you go. Please enter your email address to request account deletion. A confirmation email will be sent to you.</p>
        <?php if(session('status')): ?>
            <p style="color: green;"><?php echo e(session('status')); ?></p>
        <?php endif; ?>
        <?php if($errors->any()): ?>
            <ul style="color: red; list-style: none; padding: 0;">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        <?php endif; ?>
        <form method="POST" action="<?php echo e(route('account.deletion.request')); ?>">
            <?php echo csrf_field(); ?>
            <div class="form-group">
                <label for="email">Email Address</label>
                <input type="email" id="email" name="email" placeholder="Enter your email" required>
            </div>
            <button type="submit" class="btn">Request Deletion</button>
        </form>
        <div class="footer">
            © <?php echo e(date('Y')); ?> Dishify. All rights reserved.
        </div>
    </div>
</body>
</html>
<?php /**PATH /Users/hisham/Downloads/dbackend/resources/views/account_deletion_form.blade.php ENDPATH**/ ?>