<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <title>Dishes Gallery</title>

        <!-- Fonts -->
        <link href="https://fonts.bunny.net/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
        
        <!-- Tailwind CSS -->
        <script src="https://cdn.tailwindcss.com"></script>
        
        <!-- Font Awesome -->
        <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
        
        <script>
            tailwind.config = {
                theme: {
                    extend: {
                        fontFamily: {
                            'inter': ['Inter', 'sans-serif'],
                        },
                        colors: {
                            'primary': {
                                50: '#f0fdf4',
                                100: '#dcfce7',
                                200: '#bbf7d0',
                                300: '#86efac',
                                400: '#4ade80',
                                500: '#22d651',
                                600: '#16a34a',
                                700: '#15803d',
                                800: '#166534',
                                900: '#14532d',
                            }
                        }
                    }
                }
            }
        </script>

        <style>
            body { font-family: 'Inter', sans-serif; }
            .card-hover { transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1); }
            .card-hover:hover { transform: translateY(-4px); }
            .pagination-link { transition: all 0.2s ease-in-out; }
            .pagination-link:hover { transform: scale(1.05); }
        </style>
    </head>
    <body class="bg-gradient-to-br from-slate-50 to-green-50 min-h-screen">
        <!-- Header -->
        <header class="bg-white/80 backdrop-blur-md border-b border-gray-200/50 sticky top-0 z-50">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="flex justify-between items-center h-16">


                    <!-- Navigation -->
                    <nav class="flex items-center space-x-6">
                        <a href="<?php echo e(route('dishes.gallery')); ?>" class="text-gray-700 hover:text-primary-600 font-medium transition-colors">
                            <i class="fas fa-th-large mr-2"></i>Gallery
                        </a>
                        <?php if(Route::has('login')): ?>
                            <?php if(auth()->guard()->check()): ?>
                                <a href="<?php echo e(url('/home')); ?>" class="text-gray-700 hover:text-primary-600 font-medium transition-colors">
                                    <i class="fas fa-home mr-2"></i>Dashboard
                                </a>
                            <?php else: ?>
                                <a href="<?php echo e(route('login')); ?>" class="text-gray-700 hover:text-primary-600 font-medium transition-colors">
                                    <i class="fas fa-sign-in-alt mr-2"></i>Login
                                </a>
                                <?php if(Route::has('register')): ?>
                                    <a href="<?php echo e(route('register')); ?>" class="bg-primary-600 text-white px-4 py-2 rounded-lg hover:bg-primary-700 transition-colors font-medium">
                                        <i class="fas fa-user-plus mr-2"></i>Register
                                    </a>
                                <?php endif; ?>
                            <?php endif; ?>
                        <?php endif; ?>
                    </nav>
                </div>
            </div>
        </header>

        <!-- Main Content -->
        <main class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
            <?php if(isset($showDishes) && $showDishes): ?>
                <!-- Dishes Gallery Section -->
                <div class="space-y-8">

                    <!-- Results Count -->
                    <div class="flex items-center justify-center">
                        <p class="text-gray-600">
                            <i class="fas fa-info-circle text-primary-500 mr-2"></i>
                            Showing <?php echo e($dishes->count()); ?> of <?php echo e($dishes->total()); ?> dishes
                        </p>
                    </div>

                    <!-- Dishes Grid -->
                    <?php if($dishes->count() > 0): ?>
                        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-6">
                            <?php $__currentLoopData = $dishes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dish): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="bg-white rounded-2xl shadow-lg border border-gray-100 overflow-hidden card-hover">
                                    <!-- Dish Image Container -->
                                    <div class="relative h-48 bg-gradient-to-br from-gray-100 to-gray-200">
                                        <?php if($dish->image_url): ?>
                                            <img src="<?php echo e($dish->image_url); ?>" 
                                                 alt="<?php echo e($dish->name); ?>" 
                                                 class="w-full h-full object-cover"
                                                 onerror="this.src='https://via.placeholder.com/400x300/f3f4f6/6b7280?text=No+Image'">
                                        <?php else: ?>
                                            <div class="w-full h-full flex items-center justify-center">
                                                <i class="fas fa-utensils text-gray-400 text-4xl"></i>
                                            </div>
                                        <?php endif; ?>
                                        
                                        <!-- Cooking Time Badge -->
                                        <?php if($dish->cooking_time): ?>
                                            <div class="absolute top-3 right-3 bg-primary-600 text-white px-3 py-1 rounded-full text-xs font-semibold shadow-lg">
                                                <i class="fas fa-clock mr-1"></i><?php echo e($dish->cooking_time); ?>m
                                            </div>
                                        <?php endif; ?>
                                        
                                        <!-- Cuisine Badge -->
                                        <?php if($dish->cuisine): ?>
                                            <div class="absolute top-3 left-3 bg-white/90 backdrop-blur-sm text-gray-800 px-3 py-1 rounded-full text-xs font-semibold">
                                                <i class="fas fa-globe mr-1"></i><?php echo e($dish->cuisine); ?>

                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    
                                    <!-- Dish Info -->
                                    <div class="p-5">
                                        <h3 class="text-lg font-bold text-gray-900 mb-3 line-clamp-2">
                                            <?php echo e($dish->name); ?>

                                        </h3>
                                        
                                        <div class="space-y-2 mb-4">
                                            <?php if($dish->calories): ?>
                                                <div class="flex items-center text-sm text-gray-600">
                                                    <i class="fas fa-fire text-red-500 mr-2 w-4"></i>
                                                    <span><?php echo e($dish->calories); ?> calories</span>
                                                </div>
                                            <?php endif; ?>
                                            
                                            <?php if($dish->dish_type): ?>
                                                <div class="flex items-center text-sm text-gray-600">
                                                    <i class="fas fa-tag text-blue-500 mr-2 w-4"></i>
                                                    <span><?php echo e($dish->dish_type); ?></span>
                                                </div>
                                            <?php endif; ?>
                                            
                                            <?php if($dish->ingredients): ?>
                                                <div class="flex items-center text-sm text-gray-600">
                                                    <i class="fas fa-list text-green-500 mr-2 w-4"></i>
                                                    <span class="line-clamp-1"><?php echo e(Str::limit($dish->ingredients, 30)); ?></span>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                        
                                        <!-- View Details Button -->
                                        <a href="<?php echo e(route('dishes.gallery.show', $dish->id)); ?>" 
                                           class="w-full bg-gradient-to-r from-primary-600 to-primary-700 text-white px-4 py-3 rounded-xl text-sm font-semibold hover:from-primary-700 hover:to-primary-800 transition-all duration-300 text-center block shadow-lg hover:shadow-xl transform hover:-translate-y-0.5">
                                            <i class="fas fa-eye mr-2"></i>View Recipe
                                        </a>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        
                        <!-- Enhanced Pagination -->
                        <?php if($dishes->hasPages()): ?>
                            <div class="mt-12">
                                <div class="flex flex-col space-y-4">
                                    <!-- Page Numbers -->
                                    <div class="flex items-center justify-center space-x-2">
                                        <?php
                                            $currentPage = $dishes->currentPage();
                                            $lastPage = $dishes->lastPage();
                                            $startPage = max(1, $currentPage - 2);
                                            $endPage = min($lastPage, $currentPage + 2);
                                            
                                            if ($startPage > 1) {
                                                $startPage = max(1, $currentPage - 1);
                                            }
                                            if ($endPage < $lastPage) {
                                                $endPage = min($lastPage, $currentPage + 1);
                                            }
                                        ?>
                                        
                                        <?php if($startPage > 1): ?>
                                            <a href="<?php echo e($dishes->url(1)); ?>" class="px-3 py-2 text-gray-600 hover:text-primary-600 hover:bg-primary-50 rounded-lg pagination-link">
                                                1
                                            </a>
                                            <?php if($startPage > 2): ?>
                                                <span class="px-2 text-gray-400">...</span>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                        
                                        <?php for($page = $startPage; $page <= $endPage; $page++): ?>
                                            <?php if($page == $currentPage): ?>
                                                <span class="px-3 py-2 bg-primary-600 text-white rounded-lg font-semibold">
                                                    <?php echo e($page); ?>

                                                </span>
                                            <?php else: ?>
                                                <a href="<?php echo e($dishes->url($page)); ?>" class="px-3 py-2 text-gray-600 hover:text-primary-600 hover:bg-primary-50 rounded-lg pagination-link">
                                                    <?php echo e($page); ?>

                                                </a>
                                            <?php endif; ?>
                                        <?php endfor; ?>
                                        
                                        <?php if($endPage < $lastPage): ?>
                                            <?php if($endPage < $lastPage - 1): ?>
                                                <span class="px-2 text-gray-400">...</span>
                                            <?php endif; ?>
                                            <a href="<?php echo e($dishes->url($lastPage)); ?>" class="px-3 py-2 text-gray-600 hover:text-primary-600 hover:bg-primary-50 rounded-lg pagination-link">
                                                <?php echo e($lastPage); ?>

                                            </a>
                                        <?php endif; ?>
                                    </div>
                                    
                                    <!-- Previous/Next Navigation -->
                                    <div class="flex items-center justify-between">
                                        <!-- Previous Page -->
                                        <?php if($dishes->onFirstPage()): ?>
                                            <span class="px-6 py-3 text-gray-400 cursor-not-allowed bg-gray-100 rounded-xl">
                                                <i class="fas fa-chevron-left mr-2"></i>Previous Page
                                            </span>
                                        <?php else: ?>
                                            <a href="<?php echo e($dishes->previousPageUrl()); ?>" class="px-6 py-3 bg-primary-600 text-white hover:bg-primary-700 rounded-xl font-medium pagination-link transition-colors">
                                                <i class="fas fa-chevron-left mr-2"></i>Previous Page
                                            </a>
                                        <?php endif; ?>
                                        
                                        <!-- Next Page -->
                                        <?php if($dishes->hasMorePages()): ?>
                                            <a href="<?php echo e($dishes->nextPageUrl()); ?>" class="px-6 py-3 bg-primary-600 text-white hover:bg-primary-700 rounded-xl font-medium pagination-link transition-colors">
                                                Next Page<i class="fas fa-chevron-right ml-2"></i>
                                            </a>
                                        <?php else: ?>
                                            <span class="px-6 py-3 text-gray-400 cursor-not-allowed bg-gray-100 rounded-xl">
                                                Next Page<i class="fas fa-chevron-right ml-2"></i>
                                            </span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                
                                <!-- Page Info -->
                                <div class="text-center mt-4 text-sm text-gray-500">
                                    Page <?php echo e($dishes->currentPage()); ?> of <?php echo e($dishes->lastPage()); ?> 
                                    (<?php echo e($dishes->total()); ?> total dishes)
                                </div>
                            </div>
                        <?php endif; ?>
                    <?php else: ?>
                        <!-- No Results -->
                        <div class="text-center py-16">
                            <div class="w-24 h-24 bg-gray-100 rounded-full flex items-center justify-center mx-auto mb-6">
                                <i class="fas fa-search text-gray-400 text-3xl"></i>
                            </div>
                            <h3 class="text-2xl font-bold text-gray-900 mb-4">No dishes found</h3>
                            <p class="text-gray-600 mb-8 max-w-md mx-auto">
                                No dishes are available at the moment.
                            </p>
                        </div>
                    <?php endif; ?>
                </div>
            <?php endif; ?>

            <!-- Individual Dish Detail -->
            <?php if(isset($showDishDetail) && $showDishDetail && isset($dish)): ?>
                <div class="max-w-4xl mx-auto">
                    <!-- Back Navigation -->
                    <div class="mb-6">
                        <a href="<?php echo e(route('dishes.gallery')); ?>" class="inline-flex items-center text-primary-600 hover:text-primary-800 font-medium transition-colors">
                            <i class="fas fa-arrow-left mr-2"></i>Back to Gallery
                        </a>
                    </div>
                    
                    <!-- Dish Hero Section -->
                    <div class="bg-white rounded-2xl shadow-lg border border-gray-100 overflow-hidden mb-8">
                        <div class="relative h-96 bg-gradient-to-br from-gray-100 to-gray-200">
                            <?php if($dish->image_url): ?>
                                <img src="<?php echo e($dish->image_url); ?>" 
                                     alt="<?php echo e($dish->name); ?>" 
                                     class="w-full h-full object-cover"
                                     onerror="this.src='https://via.placeholder.com/800x400/f3f4f6/6b7280?text=No+Image'">
                            <?php else: ?>
                                <div class="w-full h-full flex items-center justify-center">
                                    <i class="fas fa-utensils text-gray-400 text-6xl"></i>
                                </div>
                            <?php endif; ?>
                            
                            <!-- Overlay with dish name -->
                            <div class="absolute bottom-0 left-0 right-0 bg-gradient-to-t from-black/70 to-transparent p-8">
                                <h1 class="text-4xl font-bold text-white mb-2"><?php echo e($dish->name); ?></h1>
                                <?php if($dish->cuisine): ?>
                                    <span class="bg-white/20 backdrop-blur-sm text-white px-4 py-2 rounded-full text-sm font-semibold">
                                        <i class="fas fa-globe mr-2"></i><?php echo e($dish->cuisine); ?>

                                    </span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Dish Information Grid -->
                    <div class="grid grid-cols-1 lg:grid-cols-1 gap-8">
                        <!-- Main Content -->
                        <div class="space-y-8">
                            <!-- Basic Info -->
                            <div class="bg-white rounded-2xl shadow-lg border border-gray-100 p-6">
                                <h2 class="text-2xl font-bold text-gray-900 mb-6">
                                    <i class="fas fa-info-circle text-primary-600 mr-3"></i>
                                    Dish Information
                                </h2>
                                
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                    <?php if($dish->cooking_time): ?>
                                        <div class="flex items-center p-4 bg-blue-50 rounded-xl">
                                            <div class="w-12 h-12 bg-blue-100 rounded-lg flex items-center justify-center mr-4">
                                                <i class="fas fa-clock text-blue-600 text-xl"></i>
                                            </div>
                                            <div>
                                                <p class="text-sm text-blue-600 font-medium">Cooking Time</p>
                                                <p class="text-lg font-bold text-gray-900"><?php echo e($dish->cooking_time); ?> minutes</p>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                    
                                    <?php if($dish->calories): ?>
                                        <div class="flex items-center p-4 bg-red-50 rounded-xl">
                                            <div class="w-12 h-12 bg-red-100 rounded-lg flex items-center justify-center mr-4">
                                                <i class="fas fa-fire text-red-600 text-xl"></i>
                                            </div>
                                            <div>
                                                <p class="text-sm text-red-600 font-medium">Calories</p>
                                                <p class="text-lg font-bold text-gray-900"><?php echo e($dish->calories); ?></p>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                    
                                    <?php if($dish->dish_type): ?>
                                        <div class="flex items-center p-4 bg-green-50 rounded-xl">
                                            <div class="w-12 h-12 bg-green-100 rounded-lg flex items-center justify-center mr-4">
                                                <i class="fas fa-tag text-green-600 text-xl"></i>
                                            </div>
                                            <div>
                                                <p class="text-sm text-green-600 font-medium">Dish Type</p>
                                                <p class="text-lg font-bold text-gray-900"><?php echo e($dish->dish_type); ?></p>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                    
                                    <?php if($dish->dish_complexity): ?>
                                        <div class="flex items-center p-4 bg-purple-50 rounded-xl">
                                            <div class="w-12 h-12 bg-purple-100 rounded-lg flex items-center justify-center mr-4">
                                                <i class="fas fa-star text-purple-600 text-xl"></i>
                                            </div>
                                            <div>
                                                <p class="text-sm text-purple-600 font-medium">Complexity</p>
                                                <p class="text-lg font-bold text-gray-900"><?php echo e($dish->dish_complexity); ?></p>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            
                            <!-- Ingredients -->
                            <?php if($dish->ingredients): ?>
                                <div class="bg-white rounded-2xl shadow-lg border border-gray-100 p-6">
                                    <h2 class="text-2xl font-bold text-gray-900 mb-6">
                                        <i class="fas fa-list text-primary-600 mr-3"></i>
                                        Ingredients
                                    </h2>
                                    <div class="prose prose-gray max-w-none">
                                        <p class="text-gray-700 leading-relaxed"><?php echo e($dish->ingredients); ?></p>
                                    </div>
                                </div>
                            <?php endif; ?>
                            
                            <!-- Instructions -->
                            <?php if($dish->instructions): ?>
                                <div class="bg-white rounded-2xl shadow-lg border border-gray-100 p-6">
                                    <h2 class="text-2xl font-bold text-gray-900 mb-6">
                                        <i class="fas fa-utensils text-primary-600 mr-3"></i>
                                        Cooking Instructions
                                    </h2>
                                    <div class="prose prose-gray max-w-none">
                                        <p class="text-gray-700 leading-relaxed"><?php echo e($dish->instructions); ?></p>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </main>

        <script>
            // Pagination functionality is handled by Laravel's built-in pagination
        </script>
    </body>
</html>
<?php /**PATH /home/ki642991/dishify-server.advisecampus.com/resources/views/welcome.blade.php ENDPATH**/ ?>