<?php
namespace App\Http\Controllers\Api;

use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\RegisterController;
use App\Http\Controllers\Api\LoginController;
use App\Http\Controllers\Api\EmailController;
use App\Http\Controllers\Api\TokenController;
use App\Http\Controllers\Api\UserController;
use App\Http\Controllers\Api\PaymentController;
use App\Http\Controllers\Api\RecipeController;
use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\StripeController;
use App\Http\Controllers\Api\AppVersionController;
use App\Http\Controllers\Api\UsersIngredientsController;
use App\Http\Controllers\AccountDeletionController;





Route::post('/register', [RegisterController::class, 'register']);
Route::post('/login', [LoginController::class, 'login']);
Route::post('/login-admin', [LoginController::class, 'loginAdmin']);


// // Google OAuth
// Route::get('auth/google', [LoginController::class, 'redirectToGoogle']);
// Route::get('auth/google/callback', [LoginController::class, 'handleGoogleCallback']);

Route::post('auth/google', [LoginController::class, 'handleGoogleCallback']);




Route::post('/emails', [EmailController::class, 'store']);

// Apply sanctum auth middleware to this route
Route::middleware('auth:sanctum')->post('/check-token', [TokenController::class, 'checkToken']);

// Keep this route if you need it
Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

Route::middleware('auth:sanctum')->put('/user/update-recipe-counts', [UserController::class, 'updateRecipeCounts']);
Route::middleware('auth:sanctum')->put('/user/update-accepted-terms', [UserController::class, 'updateAcceptedTerms']);
Route::middleware('auth:sanctum')->put('/user/handle-premium-subscription', [UserController::class, 'handlePremiumSubscription']);

Route::middleware('auth:sanctum')->put('/user/update-user-scans-count', [UserController::class, 'updateUserScansCount']);
Route::middleware('auth:sanctum')->put('/user/update-user-total-scans-count', [UserController::class, 'updateUserTotalScansCount']);


Route::middleware('auth:sanctum')->group(function () {
    Route::post('/payments', [PaymentController::class, 'store']);
    Route::get('/payments', [PaymentController::class, 'index']);
});

// Apple Pay Payment Processing Route
Route::middleware('auth:sanctum')->group(function () {
Route::post('/apple-pay', [StripeController::class, 'processApplePay']);
});

Route::middleware('auth:sanctum')->group(function () {
    Route::post('/recipes', [RecipeController::class, 'store']);
    Route::get('/recipes', [RecipeController::class, 'index']);
    Route::get('/recipes/{title}', [RecipeController::class, 'show']);
});


Route::middleware('auth:sanctum')->group(function () {
    Route::post('/dishes', [RecipeController::class, 'storeDish']);
    Route::get('/dishes', [RecipeController::class, 'getDishes']);
    Route::get('/dishes/{name}', [RecipeController::class, 'show']);
    Route::get('/search-dishes', [RecipeController::class, 'searchDishes']);
        Route::get('/recommended-dishes', [RecipeController::class, 'getRecommendedDishes']);

});

Route::middleware('auth:sanctum')->group(function () {
    Route::post('/users-ingredients', [UsersIngredientsController::class, 'store']);
    Route::get('/users-ingredients', [UsersIngredientsController::class, 'index']);
});
Route::get('/ingredients-statistics', [UsersIngredientsController::class, 'getGlobalIngredientStatistics']);


Route::post('password/email', [AuthController::class, 'sendResetLinkEmail']);
Route::post('password/reset', [AuthController::class, 'reset']);



Route::post('/create-checkout-session', [StripeController::class, 'createCheckoutSession']);
Route::post('/create-checkout-session-trial', [StripeController::class, 'createCheckoutSessionWithTrial']);
Route::post('/cancel-subscription', [StripeController::class, 'cancelSubscription']);

Route::post('/revenuecat-webhook', [StripeController::class, 'revenuecatWebhook']);


Route::post('/create-scans-checkout', [StripeController::class, 'createScanCheckoutSession']);


//android webhook
Route::post('/webhook', [StripeController::class, 'handleWebhook']);
Route::post('/webhook/scans', [StripeController::class, 'handleScanPurchaseWebhook']);
//apple webhook
Route::post('/apple-webhook', [StripeController::class, 'handleAppleWebhook']);


Route::middleware('auth:sanctum')->group(function () {
    Route::post('/save-subscription', [StripeController::class, 'saveSubscription']);
    Route::post('/cancel-apple-subscription', [StripeController::class, 'cancelAppleSubscription']);
    Route::get('/get-subscription', [StripeController::class, 'getSubscription']);
    
    Route::post('/save-apple-scan-purchase', [StripeController::class, 'saveAppleScanPurchase']);

});

Route::get('/latest-version', [AppVersionController::class, 'getLatestVersion']);

Route::post('/add-log', [StripeController::class, 'createLog']);

// Group routes that require authentication
    // API endpoint to request account deletion
    Route::post('/account-deletion', [AccountDeletionController::class, 'apiRequestDeletion'])->name('api.account.deletion.request');
    
    // API endpoint to confirm account deletion
    Route::get('/account-deletion/confirm/{token}', [AccountDeletionController::class, 'confirmDeletion'])->name('api.account.deletion.confirm');
    
    //statistics apis
Route::middleware('auth:sanctum')->group(function () {
    Route::get('/stats/total-users', [UsersController::class, 'getTotalUsers']);
    Route::get('/stats/users-by-platform', [UsersController::class, 'getUsersByPlatform']);
    Route::get('/stats/premium-users', [UsersController::class, 'getPremiumUsers']);
    Route::get('/stats/total-scans', [UsersController::class, 'getTotalScans']);
    Route::get('/stats/users-by-date', [UsersController::class, 'getUsersByDate']);
});

Route::get('/latest-version', [AppVersionController::class, 'getLatestVersion']);

Route::post('/email-unsubscribe', [EmailController::class, 'unsubscribe']);


Route::middleware('auth:sanctum')->group(function () {
    Route::post('/users-questions', [LoginController::class, 'storeUserQuestions']);
        Route::get('/users-questions', [LoginController::class, 'getUserQuestions']);

});

Route::middleware('auth:sanctum')->group(function () {
    Route::get('/pantry', [UsersIngredientsController::class, 'listPantry']);
    Route::post('/pantry', [UsersIngredientsController::class, 'addToPantry']);
    Route::put('/pantry/{id}', [UsersIngredientsController::class, 'updatePantryItem']);
    Route::delete('/pantry/{id}', [UsersIngredientsController::class, 'removeFromPantry']);
    
    Route::get('/pantry-by-expiration', [
        UsersIngredientsController::class,
        'getPantryByExpiration'
    ]);
});

