<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class TokenController extends Controller
{
    public function checkToken(Request $request)
    {
        if (Auth::guard('sanctum')->check()) {
            $user = Auth::guard('sanctum')->user();
            return response()->json([
                'valid' => true,
                'user' => $user,
                'token_info' => $request->bearerToken()
            ], 200);
        } else {
            return response()->json([
                'valid' => false,
                'message' => 'Invalid or missing token',
                'token_info' => $request->bearerToken()
            ], 401);
        }
    }
}
