<?php

namespace App\Http\Controllers\api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\AppVersion;

class AppVersionController extends Controller
{
    //
    public function getLatestVersion()
    {
        // Assuming you always keep the latest version as the last one
        $latestVersion = AppVersion::latest()->first();

        return response()->json([
            'version' => $latestVersion->version,
            'android_url'=>$latestVersion->android_url,
            'ios_url'=>$latestVersion->ios_url,
            'out_of_service'=>$latestVersion->out_of_service,
            'model_gemini'=>$latestVersion->model_gemini,
            'model_gpt'=>$latestVersion->model_gpt
        ]);
    }
}
