<?php

namespace App;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;


class Dish extends Model
{
    use HasFactory;

    // Add the table name if it is not the default 'dishes'
    protected $table = 'dishes';

    // Allow mass assignment for the specified fields
    protected $fillable = [
        'name',
        'image_url',
        'cuisine',
        'diets',
        'flavour_profile',
        'dish_type',
        'dish_complexity',
        'cooking_time',
        'cooking_style',
        'mood',
        'cooking_equipment',
        'cultural',
        'ingredients',
        'scanned_ingredients',
        'min_calories',
        'max_calories',
        'calories',
        'instructions',
    ];
    
}
