<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Auth\Notifications\VerifyEmail;
use App\Http\Controllers\EmailVerificationController;
use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\StripeController;
use App\Http\Controllers\AccountDeletionController;


/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});
// Route::get('/fix-cache', function () {
//     \Artisan::call('config:clear');
//     \Artisan::call('cache:clear');
//     \Artisan::call('config:cache');
//     return "Cache cleared and rebuilt.";
// });

Route::group(['prefix' => 'admin'], function () {
    Voyager::routes();
});

Route::get('/email/verify/{id}/{hash}', [EmailVerificationController::class, 'verify'])
    ->name('verification.verify');


// Auth::routes(['verify' => true, 'reset' => true]);

// Show the reset form
Route::get('password/reset/{token}', function($token) {
    return view('auth.passwords.reset', ['token' => $token]);
})->name('password.reset');

// Handle password reset
Route::post('password/reset', [AuthController::class, 'reset'])->name('password.update');

// Route for the password reset success page
Route::get('password/success', function () {
    return view('auth.passwords.success');
})->name('password.success');


Route::get('/checkout/success', action: [StripeController::class, 'checkoutSuccess'])->name(name: 'checkout.success');
Route::get('/checkout/cancel', [StripeController::class, 'checkoutCancel'])->name('checkout.cancel');


Route::get('/account-deletion', [AccountDeletionController::class, 'showForm'])->name('account.deletion.form');
Route::post('/account-deletion', [AccountDeletionController::class, 'requestDeletion'])->name('account.deletion.request');
Route::get('/account-deletion/confirm/{token}', [AccountDeletionController::class, 'confirmDeletion'])->name('account.deletion.confirm');




// Dishes gallery routes - Inline approach (no new files needed)
// Using different route to avoid conflict with existing Voyager dishes page
// PROTECTED: Requires authentication like Voyager admin
Route::middleware(['web', 'admin.user'])->group(function () {
    Route::get('/dishes-gallery', function () {
        $query = \App\Dish::query();
        
        // Apply filters
        if (request('cuisine')) {
            $query->where('cuisine', request('cuisine'));
        }
        
        if (request('dish_type')) {
            $query->where('dish_type', request('dish_type'));
        }
        
        if (request('cooking_time')) {
            $query->where('cooking_time', '<=', request('cooking_time'));
        }
        
        $dishes = $query->orderBy('created_at', 'desc')->paginate(12);
        $cuisines = \App\Dish::distinct()->pluck('cuisine')->filter()->values();
        $dishTypes = \App\Dish::distinct()->pluck('dish_type')->filter()->values();
        
        return view('welcome', [
            'dishes' => $dishes,
            'cuisines' => $cuisines,
            'dishTypes' => $dishTypes,
            'showDishes' => true
        ]);
    })->name('dishes.gallery');

    Route::get('/dishes-gallery/{id}', function ($id) {
        $dish = \App\Dish::findOrFail($id);
        return view('welcome', [
            'dish' => $dish,
            'showDishDetail' => true
        ]);
    })->name('dishes.gallery.show');
});

// Admin routes for dishes gallery (optional)
// PROTECTED: Requires authentication like Voyager admin
Route::middleware(['web', 'admin.user'])->group(function () {
    Route::get('/admin/dishes-gallery', function () {
        $query = \App\Dish::query();
        
        // Apply filters
        if (request('cuisine')) {
            $query->where('cuisine', request('cuisine'));
        }
        
        if (request('dish_type')) {
            $query->where('dish_type', request('dish_type'));
        }
        
        if (request('cooking_time')) {
            $query->where('cooking_time', '<=', request('cooking_time'));
        }
        
        $dishes = $query->orderBy('created_at', 'desc')->paginate(12);
        $cuisines = \App\Dish::distinct()->pluck('cuisine')->filter()->values();
        $dishTypes = \App\Dish::distinct()->pluck('dish_type')->filter()->values();
        
        return view('welcome', [
            'dishes' => $dishes,
            'cuisines' => $cuisines,
            'dishTypes' => $dishTypes,
            'showDishes' => true
        ]);
    })->name('admin.dishes.gallery');

    Route::get('/admin/dishes-gallery/{id}', function ($id) {
        $dish = \App\Dish::findOrFail($id);
        return view('welcome', [
            'dish' => $dish,
            'showDishDetail' => true
        ]);
    })->name('admin.dishes.gallery.show');
});