@extends('voyager::master')

@section('page_title', __('voyager::generic.' . (isset($dataTypeContent->id) ? 'edit' : 'add')) . ' ' . $dataType->getTranslatedAttribute('display_name_singular'))

@section('css')
<meta name="csrf-token" content="{{ csrf_token() }}">
@stop

@section('page_header')
<h1 class="page-title">
    <i class="{{ $dataType->icon }}"></i>
    {{ __('voyager::generic.' . (isset($dataTypeContent->id) ? 'edit' : 'add')) . ' ' . $dataType->getTranslatedAttribute('display_name_singular') }}
</h1>
@stop

@section('content')
<div class="page-content container-fluid">
    <form class="form-edit-add" role="form"
        action="@if(!is_null($dataTypeContent->getKey())){{ route('voyager.' . $dataType->slug . '.update', $dataTypeContent->getKey()) }}@else{{ route('voyager.' . $dataType->slug . '.store') }}@endif"
        method="POST" enctype="multipart/form-data" autocomplete="off">
        <!-- PUT Method if we are editing -->
        @if(isset($dataTypeContent->id))
            {{ method_field("PUT") }}
        @endif
        {{ csrf_field() }}

        <div class="row">
            <div class="col-md-8">
                <div class="panel panel-bordered">
                    @if (count($errors) > 0)
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <div class="panel-body">
                        <!-- Existing Fields -->
                        <div class="form-group">
                            <label for="name">{{ __('voyager::generic.name') }}</label>
                            <input type="text" class="form-control" id="name" name="name"
                                placeholder="{{ __('voyager::generic.name') }}"
                                value="{{ old('name', $dataTypeContent->name ?? '') }}">
                        </div>

                        <div class="form-group">
                            <label for="email">{{ __('voyager::generic.email') }}</label>
                            <input type="email" class="form-control" id="email" name="email"
                                placeholder="{{ __('voyager::generic.email') }}"
                                value="{{ old('email', $dataTypeContent->email ?? '') }}">
                        </div>

                        <div class="form-group">
                            <label for="password">{{ __('voyager::generic.password') }}</label>
                            @if(isset($dataTypeContent->password))
                                <br>
                                <small>{{ __('voyager::profile.password_hint') }}</small>
                            @endif
                            <input type="password" class="form-control" id="password" name="password" value=""
                                autocomplete="new-password">
                        </div>

                        <!-- Additional Fields -->
                        <div class="form-group">
                            <label for="recipes_scans_count">Recipes Scans Count</label>
                            <input type="number" class="form-control" id="recipes_scans_count"
                                name="recipes_scans_count"
                                value="{{ old('recipes_scans_count', $dataTypeContent->recipes_scans_count ?? 0) }}">
                        </div>

                        <div class="form-group">
                            <label for="recipes_refresh_count">Recipes Refresh Count</label>
                            <input type="number" class="form-control" id="recipes_refresh_count"
                                name="recipes_refresh_count"
                                value="{{ old('recipes_refresh_count', $dataTypeContent->recipes_refresh_count ?? 0) }}">
                        </div>

                        <div class="form-group">
                            <label for="premium">Premium</label>
                            <select class="form-control" id="premium" name="premium">
                                <option value="0" {{ old('premium', $dataTypeContent->premium ?? '0') == '0' ? 'selected' : '' }}>No</option>
                                <option value="1" {{ old('premium', $dataTypeContent->premium ?? '0') == '1' ? 'selected' : '' }}>Yes</option>
                            </select>
                        </div>

                        <div class="form-group">
                            <label for="accepted_terms">Accepted Terms</label>
                            <select class="form-control" id="accepted_terms" name="accepted_terms">
                                <option value="0" {{ old('accepted_terms', $dataTypeContent->accepted_terms ?? '0') == '0' ? 'selected' : '' }}>No</option>
                                <option value="1" {{ old('accepted_terms', $dataTypeContent->accepted_terms ?? '0') == '1' ? 'selected' : '' }}>Yes</option>
                            </select>
                        </div>

                        <div class="form-group">
                            <label for="expired_at">Subscription Ends At                            </label>
                            <input type="datetime-local" class="form-control" id="subscription_ends_at" name="subscription_ends_at"
                                value="{{ old('subscription_ends_at', (isset($dataTypeContent->subscription_ends_at) && $dataTypeContent->subscription_ends_at instanceof \Carbon\Carbon) ? $dataTypeContent->subscription_ends_at->format('Y-m-d\TH:i') : $dataTypeContent->subscription_ends_at) }}">
                        </div>


                        <div class="form-group">
                            <label for="customer_id">Customer Id</label>
                            <input type="text" class="form-control" id="customer_id" name="customer_id"
                                value="{{ old('customer_id', $dataTypeContent->customer_id ?? '') }}">
                        </div>

                        <div class="form-group">
                            <label for="subscription_id">Subscription Id</label>
                            <input type="text" class="form-control" id="subscription_id" name="subscription_id"
                                value="{{ old('subscription_id', $dataTypeContent->subscription_id ?? '') }}">
                        </div>

                        <div class="form-group">
                            <label for="subscription_status">Subscription Status</label>
                            <input type="text" class="form-control" id="subscription_status" name="subscription_status"
                                value="{{ old('subscription_status', $dataTypeContent->subscription_status ?? '') }}">
                        </div>

                        <div class="form-group">
                            <label for="google_id">Google Id</label>
                            <input type="text" class="form-control" id="google_id" name="google_id"
                                value="{{ old('google_id', $dataTypeContent->google_id ?? '') }}">
                        </div>

                        @can('editRoles', $dataTypeContent)
                                                <div class="form-group">
                                                    <label for="default_role">{{ __('voyager::profile.role_default') }}</label>
                                                    @php
                                                        $dataTypeRows = $dataType->{(isset($dataTypeContent->id) ? 'editRows' : 'addRows')};

                                                        $row = $dataTypeRows->where('field', 'user_belongsto_role_relationship')->first();
                                                        $options = $row->details;
                                                    @endphp
                                                    @include('voyager::formfields.relationship')
                                                </div>
                                                <!-- <div class="form-group">
                                                                                    <label for="additional_roles">{{ __('voyager::profile.roles_additional') }}</label>
                                                                                    @php
                                                                                        $row     = $dataTypeRows->where('field', 'user_belongstomany_role_relationship')->first();
                                                                                        $options = $row->details;
                                                                                    @endphp
                                                                                    @include('voyager::formfields.relationship')
                                                                                </div> -->
                        @endcan

                        @php
                            $selected_locale = $dataTypeContent->locale ?? config('app.locale', 'en');
                        @endphp
                        <div class="form-group">
                            <label for="locale">{{ __('voyager::generic.locale') }}</label>
                            <select class="form-control select2" id="locale" name="locale">
                                @foreach (Voyager::getLocales() as $locale)
                                    <option value="{{ $locale }}" {{ ($locale == $selected_locale ? 'selected' : '') }}>
                                        {{ $locale }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="panel panel panel-bordered panel-warning">
                    <div class="panel-body">
                        <div class="form-group">
                            @if(isset($dataTypeContent->avatar))
                                <img src="{{ filter_var($dataTypeContent->avatar, FILTER_VALIDATE_URL) ? $dataTypeContent->avatar : Voyager::image($dataTypeContent->avatar) }}"
                                    style="width:200px; height:auto; clear:both; display:block; padding:2px; border:1px solid #ddd; margin-bottom:10px;" />
                            @endif
                            <input type="file" data-name="avatar" name="avatar">
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <button type="submit" class="btn btn-primary pull-right save">
            {{ __('voyager::generic.save') }}
        </button>
    </form>
    <div style="display:none">
        <input type="hidden" id="upload_url" value="{{ route('voyager.upload') }}">
        <input type="hidden" id="upload_type_slug" value="{{ $dataType->slug }}">
    </div>
</div>
@stop

@section('javascript')
<script>
    $('document').ready(function () {
        $('.toggleswitch').bootstrapToggle();
    });
</script>
@stop
