<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Payment;


class PaymentController extends Controller
{
    public function store(Request $request)
    {
        $validatedData = $request->validate([
            'subscription_type' => 'required',
            'amount' => 'required',
            'currency' => 'required',
            'payment_method' => 'required',
            'recipes_scans_count' => 'required',
            'recipes_refresh_count' => 'required',
            'user_id' => 'required',
        ]);

        $payment = new Payment();
        $payment->subscription_type = $request->input('subscription_type');
        $payment->amount = $request->input('amount');
        $payment->currency = $request->input('currency');
        $payment->payment_method = $request->input('payment_method');
        $payment->recipes_scans_count = $request->input('recipes_scans_count');
        $payment->recipes_refresh_count = $request->input('recipes_refresh_count');
        $payment->user_id = $request->input('user_id');

        $payment->save();

        return response()->json(['message' => 'Payment record created', 'id' => $payment->id], 201);
    }
    public function index(Request $request)
    {
        $user = $request->user(); // This gets the authenticated user based on the token
        $payments = Payment::where('user_id', $user->id)->get();
        return response()->json($payments);
    }
}
